
#ifndef _BUTTON_H_
#define _BUTTON_H_

#include "ht32f5xxxx_01.h"

#define  BUTTON_PORT				HT_GPIOA
#define	BTN_AFIO_PORT			GPIO_PA

#define  BUTTON1   				GPIO_PIN_14		/* PA14 */
#define  BUTTON2	      		GPIO_PIN_8	/* PA8 */
#define  BUTTON3        		GPIO_PIN_3	/* PA3 */
#define  BUTTON4        		GPIO_PIN_2		/* PA2 */

#define  BTN1_ESS_PORT			AFIO_ESS_PA				/*PORT A*/
#define  BTN1_EXIT_CH			AFIO_EXTI_CH_14		/*PA14*/
#define  BTN2_ESS_PORT			AFIO_ESS_PA				/*PORT A*/
#define  BTN2_EXIT_CH			AFIO_EXTI_CH_8		/*PA8*/
#define  BTN3_ESS_PORT			AFIO_ESS_PA				/*PORT A*/
#define  BTN3_EXIT_CH			AFIO_EXTI_CH_4		/*PA3*/
#define  BTN4_ESS_PORT			AFIO_ESS_PA				/*PORT A*/
#define  BTN4_EXIT_CH			AFIO_EXTI_CH_2		/*PA2*/
#define	BTN_DEBOUNCE			200

#define	BUTTON1_IN				(BUTTON_PORT->DINR & BUTTON1)
#define	BUTTON2_IN				(BUTTON_PORT->DINR & BUTTON2)
#define	BUTTON3_IN				(BUTTON_PORT->DINR & BUTTON3)
#define	BUTTON4_IN				(BUTTON_PORT->DINR & BUTTON4)


#define  BUTTON_CONSISTENCY_DURATION   6
#define  BUTTON_REPEAT1_DURATION       (600 / BUTTON_CONSISTENCY_DURATION)
#define  BUTTON_REPEAT2_DURATION       (150 / BUTTON_CONSISTENCY_DURATION)

#define	KEY1				0x01
#define	KEY2				0x02
#define	KEY3				0x04
#define	KEY4				0x08

void 	BTN_IOConfigure(void);
void 	BTN_WakeupConfig(ControlStatus state);
bool 	BTN_GetWakeupFlag(void);
void 	BTN_ClearWakeupFlag(void);
bool 	BTN_ScanButtonStatus(void);
u8 	BTN_GetScanStatus(void);
u8 	BTN_GetButtonStatus(void);

#endif /* _BUTTON_H_ */
